function cb_m11  
% Menu 11
% Audio input device

  global persParamsDir  
  global audioInputName
  global audioOutputName
  global sfontsize
  global m11   
  
  capt = get(m11,'label'); 
  kw=sfontsize/20;
  
  devinfo = audiodevinfo ();
  c=struct2cell(devinfo.input);
  c=c(1,1,:);
  selAidef=1;
  for i =1:length(c);
    isName=strcmpi(c(1,1,i),audioInputName);
    if isName
      selAidef=i;
    end
  end
  audioInputName = c{1,1,selAidef}; 
  sn = strcat(persParamsDir,'audioDevice.mat');
  save(sn,'audioInputName','audioOutputName'); 
 
  [sel, ok] = listdlg ('ListString', c, ...
  'PromptString',capt,...
  'SelectionMode', 'Single', ...
  'InitialValue',selAidef, ...
  'ListSize',[900,400]*kw);
  
  if ~isempty(sel)
    
    cancelMeasurement
    
    audioInputName=devinfo.input(sel).Name; 
    sn = strcat(persParamsDir,'audioDevice.mat');
    save('-mat',sn,'audioInputName','audioOutputName'); 
    selAidef=sel;
    
  end 
  
end
